
import numpy as np
from tqdm import tqdm

from src.imports.import_profile import import_profile

from itertools import combinations

from src.imports.import_profile import (
    import_distances, import_coordinates, import_radius,
)

from src.imports.import_clustering_sets import import_clustering_sets


def area(p1, p2, p3):
    # Returns the absolute area of a triangle given its vertices
    return abs((p1[0]*(p2[1]-p3[1]) +
                p2[0]*(p3[1]-p1[1]) +
                p3[0]*(p1[1]-p2[1])) / 2.0)

def is_point_inside_triangle(A, a, b, c, p):
    # Calculate area of triangles ABP, BCP and CAP
    A1 = area(p, b, c)
    A2 = area(a, p, c)
    A3 = area(a, b, p)

    # Check if sum of A1, A2 and A3 is same as A (with a tolerance for floating point errors)
    return abs((A1 + A2 + A3) - A) < 1e-9

if __name__ == "__main__":

    num_tests = 100
    num_voters = 1000
    num_candidates = 100
    lower_radius = 0.1
    upper_radius = 0.33

    num_clusters = 5

    method = 'hierarchical_minavg'

    base_distances = ['norm_hamming', 'geom_hamming', 'rms_hamming',
                      'jaccard', 'geom_jaccard', 'rms_jaccard']


    for base_distance in base_distances:

        # IMPORT CLUSTERS
        c_sets_path = f"output/sampled/euclidean_2d/{method}_{base_distance}_c_sets_{num_clusters}_{num_voters}_{num_candidates}_{lower_radius}_{upper_radius}.txt"
        c_sets = import_clustering_sets(c_sets_path)

        output = []
        for t in tqdm(range(num_tests)):
            clusters = c_sets[str(t)]

            path = f'data/sampled/euclidean_2d/profiles/profile_{num_voters}_{num_candidates}_{t}_{lower_radius}_{upper_radius}'
            P = import_profile(path)

            # IMPORT COORDINATES
            c_points_path = f'data/sampled/euclidean_2d/coordinates/c_points_{num_voters}_{num_candidates}_{t}_{lower_radius}_{upper_radius}.csv'
            c_coordinates = import_coordinates(c_points_path)

            mistake_ctr = 0
            all_ctr = 0
            for cluster in clusters.values():
                for triplet in combinations(cluster, 3):
                    all_ctr += 1
                    a = c_coordinates[triplet[0]]
                    b = c_coordinates[triplet[1]]
                    c = c_coordinates[triplet[2]]
                    A = area(a, b, c)

                    for j in range(num_candidates):
                        if j not in cluster:
                            p = c_coordinates[j]

                            all_ctr += 1
                            if is_point_inside_triangle(A, a, b, c, p):
                                mistake_ctr += 1

            output.append(mistake_ctr/all_ctr)
        print('base_distance:', base_distance)
        print(output)
        output = np.array(output)
        print('avg:', np.mean(output))
        print('std:', np.std(output))